#include <sourcemod>

public Plugin:myinfo = 
{
	name = "wS_Map_Plugins",
	author = "wS / Schmidt",
	description = "Auto enabling and disabling plug-ins depending on the current map",
	version = "1.2",
	url = "http://world-source.ru/forum/118"
};

public OnPluginStart()
{
	CreateConVar("wS_Map_Plugins", "1.2", "wS_Map_Plugins version [ Plugin by World-Source.Ru ]", FCVAR_NOTIFY);
}

public OnConfigsExecuted()
{
	new Handle:kv = CreateKeyValues("wS_Map_Plugins");
	if (!FileToKeyValues(kv, "cfg/wS_Map_Plugins.txt"))
	{
		CloseHandle(kv);
		LogError("Failed to open cfg/wS_Map_Plugins.txt");
		return;
	}
	if (!KvGotoFirstSubKey(kv))
	{
		CloseHandle(kv);
		LogError("cfg/wS_Map_Plugins.txt Empty..");
		return;
	}
	decl String:MapName[125], String:buf[1][25], String:MapPrefix[25];

	// map
	GetCurrentMap(MapName, 125);
	Format(MapName, 125, "%s;", MapName);

	// prefix
	ExplodeString(MapName, "_", buf, 1, 25);
	TrimString(buf[0]);
	Format(MapPrefix, 25, "%s;", buf[0]);

	decl String:MAPS[1500], String:SmxName[75];
	do
	{
		if (KvGetSectionName(kv, SmxName, 75) && StrContains(SmxName, ".smx") != -1 && FindPluginByFile(SmxName) != INVALID_HANDLE)
		{
			KvGetString(kv, "maps", MAPS, 1500);
			if (StrContains(MAPS, MapName, false) == -1)
			{
				KvGetString(kv, "maps_prefixes", MAPS, 1500);
				if (StrContains(MAPS, MapPrefix, false) == -1)
				{
					ServerCommand("sm plugins unload %s", SmxName);
					LogMessage("Plugin '%s' unloaded", SmxName);
				}
			}
		}
	}
	while (KvGotoNextKey(kv));
	CloseHandle(kv);
}