/*
 *descriptions here
 */

new const String:PLUGIN_VERSION[60] = "1.3.12.23";

public Plugin:myinfo = {
	
	name = "RealisticBulletSound",
	author = "javalia",
	description = "make u scared",
	version = PLUGIN_VERSION,
	url = "http://www.sourcemod.net/"
	
};

//uncomment if u wanna use function of these include file
#include <sourcemod>
#include <sdktools>
//#include <cstrike>
#include "sdkhooks"
//#include "vphysics"
//#include "stocklib"

//semicolon!!!!
#pragma semicolon 1

#define MINBULLETRICSOUND 0
#define MAXBULLETRICSOUND 4
#define TOTALSOUND 5

#define RADRIGHTANGLE (FLOAT_PI / 2.0)//this value will be genarated on runtime, so it can hope always work correctly.

new const String:sounddata[][] = {

	"weapons/fx/rics/ric1.wav",
	"weapons/fx/rics/ric2.wav",
	"weapons/fx/rics/ric3.wav",
	"weapons/fx/rics/ric4.wav",
	"weapons/fx/rics/ric5.wav"

};

new const MAXKEYLENGTH = 64;
new const String:KEYDELIMITER[] = ";";
new const String:DEFAULTKEY[] = "#default";

enum READSTATUS{

	READSTATUS_NONE = 0,
	READSTATUS_SHOTGUN,
	READSTATUS_SOUNDCONFIGTARGET,
	READSTATUS_SOUNDCONFIG

};

new Handle:cvar_enablenearmisssound = INVALID_HANDLE;
new Handle:cvar_enablericochetsound = INVALID_HANDLE;
new Handle:cvar_nearmissdistance = INVALID_HANDLE;
new Handle:cvar_bulletmakesound = INVALID_HANDLE;
new Handle:cvar_nearmissadjust = INVALID_HANDLE;

new Handle:soundconfigtrie = INVALID_HANDLE;
new Handle:soundconfiglist = INVALID_HANDLE;
new Handle:shotgunconfigtrie = INVALID_HANDLE;

new Handle:soundconfigcache[2048] = {INVALID_HANDLE, ...};
new bool:isshotgun[2048];

new bool:hitpositionqueue[MAXPLAYERS + 1] = {false, ...};
new Float:lasthitposition[MAXPLAYERS + 1][3];

public OnPluginStart(){

	CreateConVar("RealisticBulletSound_version", PLUGIN_VERSION, "plugin info cvar",   FCVAR_DONTRECORD | FCVAR_NOTIFY);
	cvar_enablenearmisssound = CreateConVar("RealisticBulletSound_enablenearmisssound", "1", "1 for enable, 0 for disable");
	cvar_enablericochetsound = CreateConVar("RealisticBulletSound_enablericochetsound", "0", "1 for enable, 0 for disable");
	cvar_nearmissdistance = CreateConVar("RealisticBulletSound_nearmissdistance", "64.0", "distance to client from bullet line that let u hear the nearmiss sound");
	cvar_bulletmakesound = CreateConVar("RealisticBulletSound_bulletmakesound", "256.0", "bullet will make nearmiss sound if bullet has flied longer than this");
	cvar_nearmissadjust = CreateConVar("RealisticBulletSound_nearmissadjust", "16.0", "positive value will make clients hear nearmiss sound even bullet didnt passed away the client.\nnegative value will force the bullet to pass away client at least absolute value of this value");
	
	HookEvent("bullet_impact", event_bulletimpact);
	
	soundconfigtrie = CreateTrie();
	soundconfiglist = CreateArray();
	shotgunconfigtrie = CreateTrie();
	
}

public OnPluginEnd(){
	
	//actually, we have no need to do this
	clearConfigData();
	
	CloseHandle(soundconfigtrie);
	CloseHandle(soundconfiglist);
	CloseHandle(shotgunconfigtrie);

}

public OnMapStart(){
	
	AutoExecConfig();
	
	loadConfigData();
	
	for(new i = 0; i < TOTALSOUND; i++){
		
		PrecacheSound(sounddata[i], true);
		
	}

}

public OnClientPutInServer(client){
	
	hitpositionqueue[client] = false;
	
	//weapon`s fire is handled in ItemPostFrame(i expect it is same in css), and its called by player entity`s postthink
	SDKHook(client, SDKHook_PostThinkPost, PostThinkPostHook);

}

public OnEntityCreated(entity, const String:classname[]){
	
	if(entity >= 0 && entity <= 2047){
		
		isshotgun[entity] = false;
		GetTrieValue(shotgunconfigtrie, classname, isshotgun[entity]);
		soundconfigcache[entity] = INVALID_HANDLE;
		if(!GetTrieValue(soundconfigtrie, classname, soundconfigcache[entity])){
		
			GetTrieValue(soundconfigtrie, DEFAULTKEY, soundconfigcache[entity]);
		
		}
		
	}

}

public PostThinkPostHook(client){

	if(hitpositionqueue[client]){
		
		hitpositionqueue[client] = false;
		makebulletsound(client);
		
	}

}

public Action:event_bulletimpact(Handle:Event, const String:Name[], bool:Broadcast){
	
	decl client;

	client = GetClientOfUserId(GetEventInt(Event, "userid"));
	lasthitposition[client][0] = GetEventFloat(Event, "x");
	lasthitposition[client][1] = GetEventFloat(Event, "y");
	lasthitposition[client][2] = GetEventFloat(Event, "z");
	
	new contents, ent;
	contents = TR_GetPointContents(lasthitposition[client], ent);
	
	if((ent == 0 || ent > MaxClients) && !(contents & (MASK_WATER | CONTENTS_WINDOW)) && GetConVarBool(cvar_enablericochetsound)){
	
		//make ric sound on here
		EmitSoundToAll(sounddata[GetRandomInt(MINBULLETRICSOUND, MAXBULLETRICSOUND)], 0, SNDCHAN_STATIC, 75, SND_NOFLAGS, GetRandomFloat(0.5, 0.6), GetRandomInt(90, 110), -1, lasthitposition[client], NULL_VECTOR, true, 0.0);
	
	}
	
	if(isshotgun[GetEntPropEnt(client, Prop_Data, "m_hActiveWeapon")]){
	
		makebulletsound(client);
		
	}else{
	
		hitpositionqueue[client] = true;
	
	}
	
}

makebulletsound(client){
	
	decl Float:clienteyepos[3], Float:targetpos[3];
	decl Float:cltotargetvec[3], Float:cltobulletvec[3], Float:cltobulletdistance, Float:cltotargetdistance;
	decl Float:targetnbulletangle, Float:heardistance, Float:bulletlinelength;//i hate these symbolname.
	
	GetClientEyePosition(client, clienteyepos);
	MakeVectorFromPoints(clienteyepos, lasthitposition[client], cltobulletvec);
	cltobulletdistance = GetVectorDistance(clienteyepos, lasthitposition[client]);
	NormalizeVector(cltobulletvec, cltobulletvec);
	
	if(GetConVarBool(cvar_enablenearmisssound)){
	
		for(new i = 1; i <= MaxClients; i++){
		
			if(i != client && IsClientInGame(i)){
				
				GetClientEyePosition(i, targetpos);
				MakeVectorFromPoints(clienteyepos, targetpos, cltotargetvec);
				cltotargetdistance = GetVectorDistance(clienteyepos, targetpos);
				NormalizeVector(cltotargetvec, cltotargetvec);
				
				targetnbulletangle = ArcCosine(GetVectorDotProduct(cltotargetvec, cltobulletvec));//this is radian angle
				
				if(targetnbulletangle < RADRIGHTANGLE){
				
					bulletlinelength = Cosine(targetnbulletangle) * cltotargetdistance;
					heardistance = Sine(targetnbulletangle) * cltotargetdistance;
					
					if(heardistance <= GetConVarFloat(cvar_nearmissdistance) && bulletlinelength <= cltobulletdistance + GetConVarFloat(cvar_nearmissadjust)){
					
						//lets not make bullet sound if bullet didnt flyed long enough distance
						if(cltobulletdistance >= GetConVarFloat(cvar_bulletmakesound)){
							
							new entity = GetEntPropEnt(client, Prop_Data, "m_hActiveWeapon");
							
							if(soundconfigcache[entity] != INVALID_HANDLE){
								
								new arraysize = GetArraySize(soundconfigcache[entity]);
								
								if(arraysize != 0){
									
									new Handle:datapack = GetArrayCell(soundconfigcache[entity], GetRandomInt(0, arraysize - 1));
									decl String:soundpath[256], level, Float:volume, pitch;
									ReadPackString(datapack, soundpath, 256);
									level = ReadPackCell(datapack);
									volume = ReadPackFloat(datapack);
									pitch = ReadPackCell(datapack);
									ResetPack(datapack);
									
									//PrintToServer("%f %f %f", cltotargetdistance, RadToDeg(targetnbulletangle), heardistance);
									//EmitSoundToClient(i, sounddata[GetRandomInt(MINBULLETLTORSOUND, MAXBULLETLTORSOUND)], 0, SNDCHAN_STATIC, SNDLEVEL_GUNFIRE, SND_NOFLAGS, 0.7, SNDPITCH_NORMAL, -1, clienteyepos, cltobulletvec, false);
									EmitSoundToClient(i, soundpath, 0, SNDCHAN_STATIC, level, SND_NOFLAGS, volume, pitch, -1, clienteyepos, cltobulletvec, false);
									
								}
								
							}
							
						}
					
					}
					
				}
				
			}
		
		}
		
	}
	
}

loadConfigData(){
	
	decl String:filepath[PLATFORM_MAX_PATH];
	BuildPath(Path_SM, filepath, PLATFORM_MAX_PATH, "configs/realisticbulletsound/realisticbulletsound.txt");
	new Handle:file = OpenFile(filepath, "r"); 
	
	if(file != INVALID_HANDLE){
	
		clearConfigData();
		
		new READSTATUS:readstatus = READSTATUS_NONE;
		new Handle:configtargetlist = CreateArray(ByteCountToCells(MAXKEYLENGTH));
		
		decl String:fileline[1024];
		while(ReadFileLine(file, fileline, 1024)){
			
			TrimString(fileline);
			
			if(StrEqual(fileline, "", false) || StrContains(fileline, "//", false) == 0){
			
				continue;
			
			}else if(StrEqual(fileline, "#shotgun", false)){
				
				ClearArray(configtargetlist);
				readstatus = READSTATUS_SHOTGUN;
			
			}else if(StrEqual(fileline, "#defaultsound", false)){
				
				if(readstatus != READSTATUS_SOUNDCONFIGTARGET){
					
					ClearArray(configtargetlist);
					
				}
				
				PushArrayString(configtargetlist, DEFAULTKEY);
				
				readstatus = READSTATUS_SOUNDCONFIGTARGET;
				
			}else if(StrContains(fileline, "+", false) == 0){
				
				if(readstatus != READSTATUS_SOUNDCONFIGTARGET){
					
					ClearArray(configtargetlist);
					
				}
				
				new delimitercount = 0, delimiterposition = -1;
				new nextreadposition = strlen("+");
				while((delimiterposition = StrContains(fileline[nextreadposition], KEYDELIMITER, false)) != -1){
					
					nextreadposition += delimiterposition + strlen(KEYDELIMITER);
					delimitercount++;
				
				}
				decl String:keyname[delimitercount + 1][MAXKEYLENGTH];
				new keyamount = ExplodeString(fileline[strlen("+")], KEYDELIMITER, keyname, delimitercount + 1, MAXKEYLENGTH);
				
				for(new i = 0; i < keyamount; i++){
				
					PushArrayString(configtargetlist, keyname[i]);
				
				}
				
				readstatus = READSTATUS_SOUNDCONFIGTARGET;
			
			}else{
			
				if(readstatus == READSTATUS_SHOTGUN){
				
					SetTrieValue(shotgunconfigtrie, fileline, true);
				
				}else if(readstatus == READSTATUS_SOUNDCONFIGTARGET || readstatus == READSTATUS_SOUNDCONFIG){
				
					decl String:datas[4][256];
					if(ExplodeString(fileline, ";", datas, 4, 256) == 4){
					
						new level = StringToInt(datas[1]);
						new Float:volume = StringToFloat(datas[2]);
						new pitch = StringToInt(datas[3]);
						
						PrecacheSound(datas[0], true);
					
						for(new i = 0; i < GetArraySize(configtargetlist); i++){
						
							new Handle:soundconfig = INVALID_HANDLE;
							decl String:configtarget[MAXKEYLENGTH];
							GetArrayString(configtargetlist, i, configtarget, MAXKEYLENGTH);
							GetTrieValue(soundconfigtrie, configtarget, soundconfig);
							
							if(soundconfig == INVALID_HANDLE){
							
								soundconfig = CreateArray();
								SetTrieValue(soundconfigtrie, configtarget, soundconfig, false);
								PushArrayCell(soundconfiglist, soundconfig);
								
							}
							
							new Handle:datapack = CreateDataPack();
							WritePackString(datapack, datas[0]);
							WritePackCell(datapack, level);
							WritePackFloat(datapack, volume);
							WritePackCell(datapack, pitch);
							ResetPack(datapack);
							
							PushArrayCell(soundconfig, datapack);
						
						}
					
					}
					
					readstatus = READSTATUS_SOUNDCONFIG;
				
				}
			
			}
			
		}
		
		CloseHandle(file);
	
	}

}

clearConfigData(){

	for(new i = 0; i < GetArraySize(soundconfiglist); i++){
	
		new Handle:soundconfig = GetArrayCell(soundconfiglist, i);
		
		for(new j = 0; j < GetArraySize(soundconfig); j++){
		
			CloseHandle(GetArrayCell(soundconfig, j));
		
		}
		
		CloseHandle(soundconfig);
		
	}
	
	ClearTrie(soundconfigtrie);
	ClearTrie(shotgunconfigtrie);
	ClearArray(soundconfiglist);

}