/* Plugin Template generated by Pawn Studio */

//----------------------------------------------------------------------------
// INCLUDES
//----------------------------------------------------------------------------
#include <sourcemod>
#include <sdktools>
#include <sdkhooks>
#include <cstrike>

//----------------------------------------------------------------------------
// DEFINES 
//----------------------------------------------------------------------------
#define PLUGIN_VERSION "1.1"
#define MAXITEMS 16
#define PATH_TO_CONFIG "cfg/vipcheat/menu.txt"

#define DEBUG_LEVEL 0
// DEBUG_LEVEL >= 5 -> full debug, show all, includes forwards
// DEBUG_LEVEL >= 4 -> includes config output
// DEBUG_LEVEL >= 3 -> includes clients output
// DEBUG_LEVEL >= 2 -> includes handles output
// DEBUG_LEVEL >= 1 -> includes sv_cheats 1
// DEBUG_LEVEL >= 0 -> no debug

//----------------------------------------------------------------------------
// CONSOLE VARIABLES 
//----------------------------------------------------------------------------
new Handle:		g_hConVar_fSpeedValue				= INVALID_HANDLE;
new Handle:		g_hConVar_fShakeAmplitude			= INVALID_HANDLE;
new Handle:		g_hConVar_fShakeTime				= INVALID_HANDLE;
new Handle:		g_hConVar_bItemDraw					= INVALID_HANDLE;

//----------------------------------------------------------------------------
// SHADOW CONSOLE VARIABLES 
//----------------------------------------------------------------------------
new Float:		g_fSpeedValue;
new Float:		g_fShakeAmplitude;
new Float:		g_fShakeTime;
new bool:		g_bItemDraw;

//----------------------------------------------------------------------------
// VARIABLES 
//----------------------------------------------------------------------------
new Handle:		g_hMenu[MAXPLAYERS+1] 				= { INVALID_HANDLE, ... };
new Handle:		g_tTrueValue						= INVALID_HANDLE;

new String:		g_szMenuTitle[64];
new String:		g_szMenuLine[MAXITEMS][128];
new String:		g_szSectionName[MAXITEMS][64];
new String:		g_szModels[2][4][64];

new bool:		g_bHasAccessToFn[MAXPLAYERS+1][MAXITEMS];
new	bool:		g_bFunctionActive[MAXPLAYERS+1][MAXITEMS];

new				g_iAccessFlag[MAXITEMS];
new 			g_iItemCount;
new				g_iAmmoOffset;
new 			g_iActiveOffset;
new				g_iPrimaryOffset;

public Plugin:myinfo = 
{
	name = "[ [VIP] CHEATS ]",
	author = "Regent",
	description = "<- your own cheat menu ->",
	version = PLUGIN_VERSION,
	url = "<- http://all4css.ru/ ->"
}

//----------------------------------------------------------------------------
// FORWARDS 
//----------------------------------------------------------------------------
public OnPluginStart()
{
	#if DEBUG_LEVEL >= 5
	PrintToServer("[ [VIP] CHEATS ] OnPluginStart");
	#endif
	
	if ( FindSendPropOffs("CCSPlayer", "m_flFlashDuration") == -1 )
	{
		PrintToServer("Failed to find CCSPlayer::m_flFlashDuration offset");
	}
	if ( FindSendPropOffs("CCSPlayer", "m_flFlashMaxAlpha") == -1 )
	{
		PrintToServer("Failed to find CCSPlayer::m_flFlashMaxAlpha offset");
	}
	if ( (g_iAmmoOffset = FindSendPropInfo("CCSPlayer", "m_iAmmo")) == -1 )
	{
		PrintToServer("Failed to find CCSPlayer::m_iAmmo offset");
	}
	if ( (g_iActiveOffset = FindSendPropInfo("CCSPlayer", "m_hActiveWeapon")) == -1 )
	{
		PrintToServer("Failed to find CCSPlayer::m_hActiveWeapon offset");
	}
	if ( (g_iPrimaryOffset = FindSendPropInfo("CBaseCombatWeapon", "m_iClip1")) == -1 )
	{
		PrintToServer("Failed to find CBaseCombatWeapon::m_iClip1 offset");
	}
	
	RegConsoleCmd("vipcheat", Command_VIPCheat, "open your own cheat menu");
	
	decl String:szPath[PLATFORM_MAX_PATH];
	Format(szPath, sizeof(szPath) - 1, PATH_TO_CONFIG);
	
	new Handle:hData = CreateKeyValues("config");
	if ( !FileToKeyValues(hData, szPath) )
	{
		SetFailState("file %s not found", PATH_TO_CONFIG);
	}
	
	if ( !KvGotoFirstSubKey(hData) )
	{
		SetFailState("file %s empty", PATH_TO_CONFIG);
	}
	
	new bool:bFound = false;
	g_iItemCount = 0;
	do
	{
		KvGetSectionName(hData, g_szSectionName[g_iItemCount], sizeof(g_szSectionName[]) - 1);
		if ( StrEqual(g_szSectionName[g_iItemCount], "MENU TITLE", false) )
		{
			KvGetString(hData, "text", g_szMenuTitle, sizeof(g_szMenuTitle) - 1, "MENU TITLE NOT FOUND");
			bFound = true;
		}
		else
		{
			KvGetString(hData, "text", g_szMenuLine[g_iItemCount], sizeof(g_szMenuLine[]) - 1, "error");
			decl String:szFlag[8];
			KvGetString(hData, "flag", szFlag, sizeof(szFlag) - 1);
			g_iAccessFlag[g_iItemCount] = ReadFlagString(szFlag);
			
			#if DEBUG_LEVEL >= 4
			PrintToServer("[ [VIP] CHEATS ] found section: %s, flags: %d", g_szSectionName[g_iItemCount], g_iAccessFlag[g_iItemCount]);
			#endif
			
			g_iItemCount++;
		}
	} while (KvGotoNextKey(hData, true));
	CloseHandle(hData);
	
	#if DEBUG_LEVEL >= 4
	PrintToServer("total menu lines: %d", g_iItemCount);
	#endif
	
	if ( !bFound )
	{
		Format(g_szMenuTitle, sizeof(g_szMenuTitle) - 1, "%s", "MENU TITLE NOT FOUND");
	}
	
	g_hConVar_fSpeedValue 		= CreateConVar("sm_vipcheat_speedvalue", 		"2.0", 	"speedup value", 												0, true, 0.01);
	g_hConVar_fShakeAmplitude 	= CreateConVar("sm_vipcheat_shakeamp", 	 		"15.0", "shake amplitude", 												0, true, 1.0);
	g_hConVar_fShakeTime 		= CreateConVar("sm_vipcheat_shaketime",  		"3.0", 	"time of shake", 												0, true, 0.01);
	g_hConVar_bItemDraw 		= CreateConVar("sm_vipcheat_drawinactivefn",  	"1.0", 	"1 - inactive items will hide, 0 - items will be inactive", 	0, true, 0.0, true, 1.0);
	
	HookConVarChange(g_hConVar_fSpeedValue, 	ConVar_Callback);
	HookConVarChange(g_hConVar_fShakeAmplitude, ConVar_Callback);
	HookConVarChange(g_hConVar_fShakeTime, 		ConVar_Callback);
	HookConVarChange(g_hConVar_bItemDraw, 		ConVar_Callback);
	
	g_fSpeedValue 		= GetConVarFloat	(g_hConVar_fSpeedValue);
	g_fShakeAmplitude 	= GetConVarFloat	(g_hConVar_fShakeAmplitude);
	g_fShakeTime 		= GetConVarFloat	(g_hConVar_fShakeTime);
	g_bItemDraw			= GetConVarBool		(g_hConVar_bItemDraw)
	
	AutoExecConfig(true, "vipcheat", "vipcheat");
	
	void_ComparisonFunction();
	
	HookEvent("player_spawn", 	Event_PlayerSpawn);
	HookEvent("player_jump", 	Event_PlayerJump);
	HookEvent("player_blind", 	Event_PlayerBlind);
	HookEvent("player_death", 	Event_PlayerDeath,		EventHookMode_Pre);
	HookEvent("bullet_impact", 	Event_BulletImpact);
	
	// thx to http://forums.alliedmods.net/showthread.php?p=592803
	HookEvent("hegrenade_detonate", 	Event_GrenadeDetonate);
	HookEvent("flashbang_detonate", 	Event_GrenadeDetonate);
	HookEvent("smokegrenade_detonate", 	Event_GrenadeDetonate);
	
	strcopy(g_szModels[0][0], 63, "models/player/ct_gign.mdl");
	strcopy(g_szModels[0][1], 63, "models/player/ct_gsg9.mdl");
	strcopy(g_szModels[0][2], 63, "models/player/ct_sas.mdl");
	strcopy(g_szModels[0][3], 63, "models/player/ct_urban.mdl");
	strcopy(g_szModels[1][0], 63, "models/player/t_arctic.mdl");
	strcopy(g_szModels[1][1], 63, "models/player/t_guerilla.mdl");
	strcopy(g_szModels[1][2], 63, "models/player/t_leet.mdl");
	strcopy(g_szModels[1][3], 63, "models/player/t_phoenix.mdl");
	
	#if DEBUG_LEVEL >= 1
	ServerCommand("sv_cheats 1");
	#endif
	
	for ( new i = 1; i <= MaxClients; i++ )
	{
		if ( IsClientInGame(i) )
		{
			OnClientPutInServer(i);
			OnClientPostAdminCheck(i);
		}
	}
}

public OnMapStart()
{
	#if DEBUG_LEVEL >= 5
	PrintToServer("[ [VIP] CHEATS ] OnMapStart");
	#endif
	
	for (new i = 0; i < 2; i++)
		for (new j = 0; j < 4; j++)
		{
			PrecacheModel(g_szModels[i][j]);
			#if DEBUG_LEVEL >= 4
			PrintToServer("[ [VIP] CHEATS ] Precached Model: %s", g_szModels[i][j]);
			#endif
		}
}

public OnClientPutInServer(iClient)
{
	SDKHook(iClient, SDKHook_OnTakeDamage, OnTakeDamage);
}

public OnClientPostAdminCheck(iClient)
{
	#if DEBUG_LEVEL >= 5
	PrintToServer("[ [VIP] CHEATS ] OnClientPostAdminCheck %d", iClient);
	#endif
	
	if ( g_hMenu[iClient] != INVALID_HANDLE )
	{
		CloseHandle(g_hMenu[iClient]);
		g_hMenu[iClient] = INVALID_HANDLE;
	}
	
	//new iFlags = GetUserFlagBits(iClient);
	for (new i = 0; i < g_iItemCount; i++)
	{
		// if ( iFlags & g_iAccessFlag[i] )
		if ( CheckCommandAccess(iClient, "vipcheatcommand", g_iAccessFlag[i]) )
		{
			g_bHasAccessToFn[iClient][i] = true;
		}
		else
		{
			g_bHasAccessToFn[iClient][i] = false;
		}
		g_bFunctionActive[iClient][i] = false;
		
		#if DEBUG_LEVEL >= 3
		PrintToServer("[ [VIP] CHEATS ] Access to %d item: %d", i, g_bHasAccessToFn[iClient][i]);
		#endif
	}
	
	g_hMenu[iClient] = handle_CreateCheatMenu(iClient);
}

public OnClientDisconnect(iClient)
{
	#if DEBUG_LEVEL >= 5
	PrintToServer("[ [VIP] CHEATS ] OnClientDisconnect %d", iClient);
	#endif
	
	if ( g_hMenu[iClient] != INVALID_HANDLE )
	{
		CloseHandle(g_hMenu[iClient]);
		g_hMenu[iClient] = INVALID_HANDLE;
	}
}

//----------------------------------------------------------------------------
// FUNCTIONS 
//----------------------------------------------------------------------------
Handle:handle_CreateCheatMenu(iClient)
{
	new Handle:hMenu = CreateMenu(Handle_CheatMenu);
	SetMenuTitle(hMenu, "%s\n \n", g_szMenuTitle);
	
	for (new i = 0; i < g_iItemCount; i++)
	{
		decl String:szLine[128];
		if ( g_bHasAccessToFn[iClient][i] )
		{
			if ( g_bFunctionActive[iClient][i] )
			{
				Format(szLine, sizeof(szLine) - 1, "%s: Выключить", g_szMenuLine[i]);
			}
			else 
			{
				Format(szLine, sizeof(szLine) - 1, "%s: Включить", g_szMenuLine[i]);
			}
			AddMenuItem(hMenu, g_szSectionName[i], szLine);
		}
		else
		{
			if ( g_bItemDraw )
			{
				Format(szLine, sizeof(szLine) - 1, "%s [Нет Доступа]", g_szMenuLine[i]);
				AddMenuItem(hMenu, g_szSectionName[i], szLine, ITEMDRAW_DISABLED);
			}
		}
	}
	
	return hMenu;
}

void_ComparisonFunction()
{
	g_tTrueValue = CreateTrie();
	
	SetTrieValue(g_tTrueValue, "speedup", 0);
	SetTrieValue(g_tTrueValue, "antienemydamage", 1);
	SetTrieValue(g_tTrueValue, "noff", 2);
	SetTrieValue(g_tTrueValue, "nootherdamage", 3);
	SetTrieValue(g_tTrueValue, "antiflash", 4);
	SetTrieValue(g_tTrueValue, "unlimgrenades", 5);
	SetTrieValue(g_tTrueValue, "unlimammo", 6);
	SetTrieValue(g_tTrueValue, "respawn", 7);
	SetTrieValue(g_tTrueValue, "camouflage", 8);
	SetTrieValue(g_tTrueValue, "shake", 9);
	SetTrieValue(g_tTrueValue, "longjump", 10);
	SetTrieValue(g_tTrueValue, "oneshot", 11);
	SetTrieValue(g_tTrueValue, "hsonly", 12);
	SetTrieValue(g_tTrueValue, "knifemaster", 13);
}

void_ChangeClientModel(iClient)
{
	#if DEBUG_LEVEL >= 3
	PrintToServer("[ [VIP] CHEATS ] Changing model %d", iClient);
	#endif
	
	if ( GetClientTeam(iClient) == CS_TEAM_T )
	{
		SetEntityModel(iClient, g_szModels[0][GetRandomInt(0, 3)]);
	}
	else if ( GetClientTeam(iClient) == CS_TEAM_CT )
	{
		SetEntityModel(iClient, g_szModels[1][GetRandomInt(0, 3)]);
	}
}

void_GiveGrenade(iClient)
{
	if ( !bool_ClientHasWeapon(iClient, 44) )
	{
		GivePlayerItem(iClient, "weapon_hegrenade");
	}
	if ( !bool_ClientHasWeapon(iClient, 48) )
	{
		GivePlayerItem(iClient, "weapon_flashbang");
	}
	if ( !bool_ClientHasWeapon(iClient, 52) )
	{
		GivePlayerItem(iClient, "weapon_smokegrenade");
	}
}

bool:bool_ClientHasWeapon(iClient, iOffset)
{
	// 44 - HE
	// 48 - FLASH
	// 52 - SMOKE
	return ( GetEntData(iClient, g_iAmmoOffset + iOffset) != 0 )
}

//----------------------------------------------------------------------------
// HANDLES
//----------------------------------------------------------------------------
public Handle_CheatMenu(Handle:hMenu, MenuAction:action, iClient, iInfo)
{
	if ( action == MenuAction_Select )
	{
		decl String:szInfo[32];
		GetMenuItem(hMenu, iInfo, szInfo, sizeof(szInfo) - 1);
		
		#if DEBUG_LEVEL >= 2
		PrintToServer("[ [VIP] CHEATS ] Selected %s", szInfo);
		#endif
		
		new iAction;
		if ( GetTrieValue(g_tTrueValue, szInfo, iAction) )
		{
			g_bFunctionActive[iClient][iAction] = !g_bFunctionActive[iClient][iAction];
		
			decl String:szLine[128];
			if ( g_bFunctionActive[iClient][iAction] )
			{
				Format(szLine, sizeof(szLine) - 1, "%s: Выключить", g_szMenuLine[iInfo]);
			}
			else 
			{
				Format(szLine, sizeof(szLine) - 1, "%s: Включить", g_szMenuLine[iInfo]);
			}
		
			InsertMenuItem(hMenu, iInfo, szInfo, szLine);
			RemoveMenuItem(hMenu, iInfo + 1);
			
			switch (iAction)
			{
				case 0:
				{
					if ( g_bFunctionActive[iClient][iAction] )
					{
						if ( IsPlayerAlive(iClient) )
						{
							SetEntPropFloat(iClient, Prop_Data, "m_flLaggedMovementValue", g_fSpeedValue);
						}
					}
					else
					{
						SetEntPropFloat(iClient, Prop_Data, "m_flLaggedMovementValue", 1.0);
					}
				}
				case 5:
				{
					if ( IsPlayerAlive(iClient) )
					{
						void_GiveGrenade(iClient);
					}
				}
				case 7:
				{
					if ( !IsPlayerAlive(iClient) )
					{
						CS_RespawnPlayer(iClient);
					}
				}
				case 8:
				{
					if ( IsPlayerAlive(iClient) )
					{
						void_ChangeClientModel(iClient);
					}
				}
			}
		}
		
		DisplayMenuAtItem(g_hMenu[iClient], iClient, GetMenuSelectionPosition(), MENU_TIME_FOREVER);
	}
	return;
}

//----------------------------------------------------------------------------
// EVENTS
//----------------------------------------------------------------------------
public Action:Event_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new iClient = GetClientOfUserId(GetEventInt(event, "userid")), 
		iFn;
	
	if ( GetTrieValue(g_tTrueValue, "speedup", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			CreateTimer(0.1, TSpeed_Callback, iClient);
		}
	}
	if ( GetTrieValue(g_tTrueValue, "camouflage", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			void_ChangeClientModel(iClient);
		}
	}
	if ( GetTrieValue(g_tTrueValue, "unlimgrenades", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			void_GiveGrenade(iClient);
		}
	}
	
	return Plugin_Continue;
}

public Action:Event_GrenadeDetonate(Handle:event, const String:name[], bool:dontBroadcast)
{
	new iClient = GetClientOfUserId(GetEventInt(event, "userid")), 
		iFn;
	
	if ( GetTrieValue(g_tTrueValue, "unlimgrenades", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			if ( StrEqual(name, "hegrenade_detonate") )
			{
				GivePlayerItem(iClient, "weapon_hegrenade");
			}
			else if ( StrEqual(name, "flashbang_detonate") )
			{
				GivePlayerItem(iClient, "weapon_flashbang");
			} 
			else if ( StrEqual(name, "smokegrenade_detonate") )
			{
				GivePlayerItem(iClient, "weapon_smokegrenade");
			}
		}
	}
	
	return Plugin_Continue;
}

public Action:Event_PlayerJump(Handle:event, const String:name[], bool:dontBroadcast)
{
	new iClient = GetClientOfUserId(GetEventInt(event, "userid")), 
		iFn;
		
	if ( GetTrieValue(g_tTrueValue, "longjump", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			decl Float:fVelocity[3];
			fVelocity[0] = GetEntPropFloat(iClient, Prop_Send, "m_vecVelocity[0]");
			fVelocity[1] = GetEntPropFloat(iClient, Prop_Send, "m_vecVelocity[1]");
			fVelocity[2] = GetEntPropFloat(iClient, Prop_Send, "m_vecVelocity[2]");
			SetEntPropVector(iClient, Prop_Send, "m_vecBaseVelocity", fVelocity);
		}
	}
	
	return Plugin_Continue;
}

public Action:Event_PlayerBlind(Handle:event, const String:name[], bool:dontBroadcast)
{
	new iClient = GetClientOfUserId(GetEventInt(event, "userid")), 
		iFn;
		
	if ( GetTrieValue(g_tTrueValue, "antiflash", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			SetEntPropFloat(iClient, Prop_Send, "m_flFlashMaxAlpha", 0.5);
			SetEntPropFloat(iClient, Prop_Send, "m_flFlashDuration", 0.0);
		}
	}
	
	return Plugin_Continue;
}

public Action:Event_PlayerDeath(Handle:event, const String:name[], bool:dontBroadcast)
{
	new iClient = GetClientOfUserId(GetEventInt(event, "userid")), 
		iAttacker = GetClientOfUserId(GetEventInt(event, "attacker")), 
		iFn;
		
	if ( GetTrieValue(g_tTrueValue, "respawn", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			CreateTimer(2.5, TRespawn_Callback, iClient);
		}
	}
	if ( GetTrieValue(g_tTrueValue, "hsonly", iFn) )
	{
		if ( g_bFunctionActive[iAttacker][iFn] )
		{
			SetEventBool(event, "headshot", true);
		}
	}
}

public Action:Event_BulletImpact(Handle:event, const String:name[], bool:dontBroadcast)
{
	new iClient = GetClientOfUserId(GetEventInt(event, "userid")), 
		iFn;
		
	if ( GetTrieValue(g_tTrueValue, "unlimammo", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			new iWeapon = GetEntDataEnt2(iClient, g_iActiveOffset);
			if ( IsValidEdict(iWeapon) )
				SetEntData(iWeapon, g_iPrimaryOffset, 30);
		}
	}
}

//----------------------------------------------------------------------------
// CALLBACKS
//----------------------------------------------------------------------------
public ConVar_Callback(Handle:cvar, const String:oldVal[], const String:newVal[])
{
	if ( cvar == g_hConVar_fSpeedValue)
	{
		g_fSpeedValue = GetConVarFloat(g_hConVar_fSpeedValue);
	}
	else if ( cvar == g_hConVar_fShakeAmplitude )
	{
		g_fShakeAmplitude = GetConVarFloat(g_hConVar_fShakeAmplitude);
	}
	else if ( cvar == g_hConVar_fShakeTime )
	{
		g_fShakeTime = GetConVarFloat(g_hConVar_fShakeTime);
	}
	else if ( cvar == g_hConVar_bItemDraw)
	{
		g_bItemDraw = GetConVarBool(g_hConVar_bItemDraw);
	}
}
public Action:TRespawn_Callback(Handle:hTimer, any:iClient)
{
	if ( !IsPlayerAlive(iClient) )
	{
		CS_RespawnPlayer(iClient);
	}
}
public Action:TSpeed_Callback(Handle:hTimer, any:iClient)
{
	if ( IsPlayerAlive(iClient) )
	{
		SetEntPropFloat(iClient, Prop_Data, "m_flLaggedMovementValue", g_fSpeedValue);
	}
}
//----------------------------------------------------------------------------
// COMMANDS
//----------------------------------------------------------------------------
public Action:Command_VIPCheat(iClient, args)
{
	DisplayMenu(g_hMenu[iClient], iClient, MENU_TIME_FOREVER);
	
	return Plugin_Handled;
}

//----------------------------------------------------------------------------
// SDKHOOKS
//----------------------------------------------------------------------------
public Action:OnTakeDamage(iClient, &iAttacker, &inflictor, &Float:damage, &damagetype)
{
	new iFn;
	if ( GetTrieValue(g_tTrueValue, "antienemydamage", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			if ( iAttacker > 0 && iAttacker <= MaxClients )
			{
				if ( GetClientTeam(iClient) != GetClientTeam(iAttacker) )
				{
					damage = 0.0;
					return Plugin_Changed;
				}
			}
		}
	}
	if ( GetTrieValue(g_tTrueValue, "noff", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			if ( iAttacker > 0 && iAttacker <= MaxClients )
			{
				if ( GetClientTeam(iClient) == GetClientTeam(iAttacker) && iClient != iAttacker )
				{
					damage = 0.0;
					return Plugin_Changed;
				}
			}
		}
	}
	if ( GetTrieValue(g_tTrueValue, "nootherdamage", iFn) )
	{
		if ( g_bFunctionActive[iClient][iFn] )
		{
			if ( iAttacker < 1 || iAttacker > MaxClients )
			{
				damage = 0.0;
				return Plugin_Changed;
			}
		}
	}
	
	if ( iAttacker > 0 && iAttacker <= MaxClients )
	{
		if ( GetTrieValue(g_tTrueValue, "shake", iFn) )
		{
			if ( g_bFunctionActive[iAttacker][iFn] )
			{
				// thx to http://forums.alliedmods.net/showthread.php?t=139646
				new Handle:hBf = StartMessageOne("Shake", iClient);
				if( hBf != INVALID_HANDLE )
				{
					BfWriteByte(hBf,  0);
					BfWriteFloat(hBf, g_fShakeAmplitude);
					BfWriteFloat(hBf, 1.0);
					BfWriteFloat(hBf, g_fShakeTime);
					EndMessage();
				}
			}
		}
		if ( GetTrieValue(g_tTrueValue, "knifemaster", iFn) )
		{
			if ( g_bFunctionActive[iAttacker][iFn] )
			{
				// thx to http://forums.alliedmods.net/showthread.php?t=218015
				new iEntity = GetEntPropEnt(iAttacker, Prop_Send, "m_hActiveWeapon");
				if ( iEntity > MaxClients )
				{
					new String:szClassName[15];
					GetEntityClassname(iEntity, szClassName, sizeof(szClassName));
					if ( StrEqual(szClassName[7], "knife") )
					{
						damage = float(GetEntProp(iClient, Prop_Send, "m_iHealth"));
						return Plugin_Changed;
					}
				}
			}
		}
		if ( GetTrieValue(g_tTrueValue, "oneshot", iFn) )
		{
			if ( g_bFunctionActive[iAttacker][iFn] )
			{
				damage = float(GetEntProp(iClient, Prop_Send, "m_iHealth"));
				return Plugin_Changed;
			}
		}
	}
	return Plugin_Continue;
}