#pragma semicolon 1
#include <sourcemod>

public Plugin:myinfo = 
{
	name	= "Delay Before Firing",
	author	= "wS (World-Source.Ru)",
	version = "1.0.1"
};

#define ITEM_SIZE 20

new Float:g_fCvarSec, Float:g_fSec;
new Handle:g_Trie, g_Trie_Size;
new String:g_Item[ITEM_SIZE];

public OnPluginStart()
{
	g_Trie = CreateTrie();

	new Handle:cvar = CreateConVar("delay_before_firing", "0.2", "Задержка между выстрелами", _, true, 0.0);
	g_fCvarSec = GetConVarFloat(cvar); HookConVarChange(cvar, cvar_changed);

	RegAdminCmd("set_delay_before_firing", set_delay_before_firing, ADMFLAG_ROOT);
	HookEvent("weapon_fire", weapon_fire);
}

public cvar_changed(Handle:cvar, const String:OldValue[], const String:NewValue[])
{
	g_fCvarSec = StringToFloat(NewValue);
}


///


public OnMapStart()
{
	g_Trie_Size = 0;
	ClearTrie(g_Trie);
}

public weapon_fire(Handle:event, const String:name[], bool:silent)
{
	if ((g_fSec = g_fCvarSec) < 0.2 && g_Trie_Size < 1)
		return;

	if (g_Trie_Size > 0)
	{
		GetEventString(event, "weapon", g_Item, ITEM_SIZE);
		if (!GetTrieValue(g_Trie, g_Item, g_fSec))
			return;
	}

	SetEntPropFloat(GetClientOfUserId(GetEventInt(event, "userid")), Prop_Send, "m_flNextAttack", GetGameTime() + g_fSec);
}


///


public Action:set_delay_before_firing(client, args)
{
	if (args != 2)
	{
		if (client > 0) PrintToConsole(client, "Syntax: set_delay_before_firing <item> <sec>");
		return Plugin_Handled;
	}

	decl String:str_item[ITEM_SIZE], String:str_sec[5];
	GetCmdArg(1, str_item, ITEM_SIZE); GetCmdArg(2, str_sec, 5);
	new Float:S = StringToFloat(str_sec);
	if (S > 0.1 && SetTrieValue(g_Trie, str_item, S, true) || S < 0.2 && RemoveFromTrie(g_Trie, str_item))
	{
		g_Trie_Size = GetTrieSize(g_Trie);
	}

	return Plugin_Handled;
}