#if defined _shop_games_included
 #endinput
#endif
#define _shop_games_included

#define GVERSION	"1.1.0"
#define GPREFIX		"\x04[Games]\x01"
#define GTITLE		"Игры на двоих"

/**
 *	Called when a player agrees to play
 *	-
 *	@param client			Client index
 *	-
 *	@noreturn
*/
functag public FuncStartGame(client);

/**
 *	Adds game to the list of games
 *	-
 *	@param game_id			Unique identifier of the game
 *	@param game_name		Name to display
 *	@param callback			Callback when a player agrees to play
 *	-
 *	@noreturn
*/
native Games_RegisterGame(const String:game_id[], const String:game_name[], FuncStartGame:callback);

/**
 *	Gets client valid
 *	-
 *	@param client			Client index
 *	@param credits			Amount credits minimum
 *	-
 *	@return true if client in game if not fake client and if has specified amount of credits
*/
native bool:Games_IsValidClient(client, credits = 0);

/**
 *	Gets client is playing with someone
 *	-
 *	@param client			Client index
 *	-
 *	@return true if client is playing with someone
*/
native bool:Games_IsClientInGame(client);

/**
 *	Gets client enemy
 *	-
 *	@param client			Client index
 *	-
 *	@return client enemy
*/
native Games_GetClientEnemy(client);

/**
 *	Gets time to take action in game from cfg
 *	-
 *	@noparam
 *	-
 *	@return Time
*/
native Games_GetGameTime();

/**
 *	Set Games_IsClientInGame to false
 *	-
 *	@param client1			Client1 index
 *	@param client2			Client2 index
 *	-
 *	@noreturn
*/
native Games_ResetGame(client1, client2);

/**
 *	Give / Take credits. Displays results
 *	-
 *	@param client			Client index
 *	@param game_name		Game title
 *	@param buffer1			Results client1
 *	@param buffer2			Results client2
 *	@param win				Is win client
 *	-
 *	@noreturn
*/
native Games_ResultGame(client, const String:game_name[], const String:buffer1[], const String:buffer2[], bool:win = false);

public SharedPlugin:__pl_shop_games =
{
	name = "shop_games",
	file = "shop_games.smx",
#if defined REQUIRE_PLUGIN
	required = 1,
#else
	required = 0,
#endif
};

#if defined REQUIRE_PLUGIN
public __pl_shop_games_SetNTVOptional()
{
	MarkNativeAsOptional("Games_RegisterGame");
	MarkNativeAsOptional("Games_IsValidClient");
	MarkNativeAsOptional("Games_IsClientInGame");
	MarkNativeAsOptional("Games_GetClientEnemy");
	MarkNativeAsOptional("Games_GetGameTime");
	MarkNativeAsOptional("Games_ResetGame");
	MarkNativeAsOptional("Games_ResultGame");
}
#endif