#pragma semicolon 1

#include <sourcemod>
#include <clientprefs>
#include <shop>
#include <shop_games>

new Handle:	g_hRulesUrl;
new Handle:	g_hCommission;
new Handle:	g_hConfirmTime;
new Handle:	g_hStartTime;
new Handle:	g_hGameTime;

new String:	g_sRulesUrl[512];
new			g_iCommission;
new			g_iConfirmTime;
new			g_iStartTime;
new			g_iGameTime;

new Handle:	Games;

new Handle:	g_hCookieResultMenu;
new bool:	g_bClientCookie[MAXPLAYERS+1][32];
new bool:	g_bClientCookieResult[MAXPLAYERS+1];

enum Bets
{
	Amount,
	Name
}

new String:g_sBets[35][Bets][64];

enum Options
{
	Game,
	Bet,
	Target,
	Started
}

new GameOptions[MAXPLAYERS+1][Options];

public APLRes:AskPluginLoad2(Handle:myself, bool:late, String:error[], err_max)
{
	CreateNative("Games_RegisterGame",		Native_RegisterGame);
	CreateNative("Games_IsValidClient",		Native_IsValidClient);
	CreateNative("Games_IsClientInGame",	Native_IsClientInGame);
	CreateNative("Games_GetClientEnemy",	Native_GetClientEnemy);
	CreateNative("Games_GetGameTime",		Native_GetGameTime);
	CreateNative("Games_ResetGame",			Native_ResetGame);
	CreateNative("Games_ResultGame",		Native_ResultGame);

	RegPluginLibrary("shop_games");
	return APLRes_Success;
}

public Plugin:myinfo =
{
	name = "[Shop] Games Core",
	author = "Monroe",
	version = GVERSION
};

public OnPluginStart()
{
	Games =				CreateArray(4);

	g_hRulesUrl =		CreateConVar("sm_shop_games_rulesurl",		"",		"Ссылка на страницу с правилами.", FCVAR_PLUGIN);
	g_hCommission =		CreateConVar("sm_shop_games_commission",	"10",	"Комиссия в %.", FCVAR_PLUGIN, true, 1.0, true, 50.0);
	g_hConfirmTime =	CreateConVar("sm_shop_games_confirmtime",	"20",	"Через сколько секунд предложение об игре будет отменено.", FCVAR_PLUGIN, true, 10.0, true, 60.0);
	g_hStartTime =		CreateConVar("sm_shop_games_starttime",		"3",	"Через сколько секунд начнется игра после подтверждения.", FCVAR_PLUGIN, true, 2.0, true, 10.0);
	g_hGameTime =		CreateConVar("sm_shop_games_gametime",		"20",	"Через сколько секунд игра завершится, если игрок не совершит действие.", FCVAR_PLUGIN, true, 10.0, true, 30.0);

	AutoExecConfig(true,				"shop_games", "shop");

	HookConVarChange(g_hRulesUrl,		OnConVarChange);
	HookConVarChange(g_hCommission,		OnConVarChange);
	HookConVarChange(g_hConfirmTime,	OnConVarChange);
	HookConVarChange(g_hStartTime,		OnConVarChange);
	HookConVarChange(g_hGameTime,		OnConVarChange);

	RegConsoleCmd("sm_games",			Command_Games, "Show main menu");

	LoadBets();
	if(Shop_IsStarted()) Shop_Started();
}

RemoveGame(String:game[])
{
	decl Handle:trie, String:buffer[32];
	for(new i = 0; i < GetArraySize(Games); i++)
	{
		trie = GetArrayCell(Games, i);

		GetTrieString(trie, "id", buffer, sizeof(buffer));
		if(StrEqual(game, buffer))
		{
			RemoveFromArray(Games, i);
			break;
		}
	}
}

public Native_RegisterGame(Handle:plugin, params)
{
	decl String:buffer[128]; new Handle:trie = CreateTrie();

	GetNativeString(1, buffer, sizeof(buffer));
	SetTrieString(trie, "id", buffer, true);
	RemoveGame(buffer);

	Format(buffer, sizeof(buffer), "shop_game_%s", buffer);
	new Handle:cookie = RegClientCookie(buffer, "Ignoring game", CookieAccess_Private);
	SetTrieValue(trie, "cookie", cookie, true);

	GetNativeString(2, buffer, sizeof(buffer));
	SetTrieString(trie, "name", buffer, true);

	SetTrieValue(trie, "plugin", plugin, true);
	SetTrieValue(trie, "func", GetNativeCell(3), true);

	PushArrayCell(Games, trie);

	CheckAllClientsCookie();
}

public Native_IsValidClient(Handle:plugin, params)	return IsValidClient(GetNativeCell(1), GetNativeCell(2));

public Native_IsClientInGame(Handle:plugin, params)	return GameOptions[GetNativeCell(1)][Started];

public Native_GetClientEnemy(Handle:plugin, params)	return GameOptions[GetNativeCell(1)][Target];

public Native_GetGameTime(Handle:plugin, params)		return g_iGameTime;

public Native_ResetGame(Handle:plugin, params)		ResetGame(GetNativeCell(1), GetNativeCell(2));

public Native_ResultGame(Handle:plugin, params)
{
	decl String:buffer[3][1024];
	GetNativeString(2, buffer[0], sizeof(buffer[]));
	GetNativeString(3, buffer[1], sizeof(buffer[]));
	GetNativeString(4, buffer[2], sizeof(buffer[]));

	ResultGame(GetNativeCell(1), buffer[0], buffer[1], buffer[2], GetNativeCell(5));
}

public OnConfigsExecuted()
{
	g_hCookieResultMenu = RegClientCookie("shop_game_result", "Off result menu", CookieAccess_Private);

	CheckAllClientsCookie();
	RefreshConVarCache();
}

public OnConVarChange(Handle:convar, const String:oldValue[], const String:newValue[]) RefreshConVarCache();

RefreshConVarCache()
{
	GetConVarString(g_hRulesUrl, g_sRulesUrl, sizeof(g_sRulesUrl));
	g_iCommission =		GetConVarInt(g_hCommission);
	g_iConfirmTime =	GetConVarInt(g_hConfirmTime);
	g_iStartTime =		GetConVarInt(g_hStartTime);
	g_iGameTime =		GetConVarInt(g_hGameTime);
}

public OnClientPutInServer(client) CheckClientCookie(client);

public OnClientDisconnect(client) GameOptions[client][Started] = false;

public OnPluginEnd() Shop_UnregisterMe();

LoadBets()
{
	decl String:path[PLATFORM_MAX_PATH];
	Shop_GetCfgFile(path, sizeof(path), "games.txt");

	new Handle:kv = CreateKeyValues("Games");
	FileToKeyValues(kv, path);

	if(KvJumpToKey(kv, "Bets", false) && KvGotoFirstSubKey(kv, false))
	{
		new count;
		decl String:amount[32], String:name[64];
		do
		{
			if(KvGetSectionName(kv, amount, sizeof(amount)))
			{
				KvGetString(kv, NULL_STRING, name, sizeof(name));
				if(amount[0])
				{
					strcopy(g_sBets[count][Amount], sizeof(g_sBets[][]), amount);
					strcopy(g_sBets[count][Name], sizeof(g_sBets[][]), name);

					count++;
				}
			}
		}
		while(KvGotoNextKey(kv, false));
	}
	CloseHandle(kv);
}

CheckAllClientsCookie() for(new i = 1; i <= MaxClients; i++) CheckClientCookie(i);

CheckClientCookie(client)
{
	if(IsValidClient(client))
	{
		decl String:buffer[10], Handle:trie, Handle:cookie;
		for(new i = 0; i < GetArraySize(Games); i++)
		{
			trie = GetArrayCell(Games, i);

			g_bClientCookie[client][i] = false;
			GetTrieValue(trie, "cookie", cookie);
			GetClientCookie(client, cookie, buffer, sizeof(buffer));

			if(StrEqual(buffer, "1")) g_bClientCookie[client][i] = true;
		}

		GetClientCookie(client, g_hCookieResultMenu, buffer, sizeof(buffer));
		if(StrEqual(buffer, "1")) g_bClientCookieResult[client] = true;
	}
}

public Shop_Started() Shop_AddToFunctionsMenu(FunctionDisplay, FunctionSelect);

public FunctionDisplay(client, String:buffer[], maxlength)
{
	decl String:title[64];
	FormatEx(title, sizeof(title), "%s [Комиссия: %i%%]", GTITLE, g_iCommission);

	strcopy(buffer, maxlength, title);
}

public bool:FunctionSelect(client)
{
	ShowMenu_Main(client);

	return true;
}

bool:IsValidClient(client, credits = 0) return IsClientInGame(client) && !IsFakeClient(client) ? Shop_GetClientCredits(client) >= credits ? true : false : false;

public Action:Command_Games(client, args)
{
	if(IsValidClient(client)) ShowMenu_Main(client);

	return Plugin_Handled;
}

SetTitleMenu(Handle:menu, client) SetMenuTitle(menu, "%s \nКредитов: %i \n \n", GTITLE, Shop_GetClientCredits(client));

ShowMenu_Main(client)
{
	new Handle:menu = CreateMenu(Main_MenuHandler);
	SetTitleMenu(menu, client);

	AddMenuItem(menu, "", "Играть", GameOptions[client][Started] ? ITEMDRAW_DISABLED : ITEMDRAW_DEFAULT);
	AddMenuItem(menu, "", "", ITEMDRAW_SPACER);
	AddMenuItem(menu, "", "Правила");
	AddMenuItem(menu, "", "Настройки");

	SetMenuExitBackButton(menu, true);
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public Main_MenuHandler(Handle:menu, MenuAction:action, client, param)
{
	if(action == MenuAction_Select)
	{
		switch(param)
		{
			case 0: ShowMenu_Games(client);
			case 2:
			{
				ShowMOTDPanel(client, "Правила", g_sRulesUrl, MOTDPANEL_TYPE_URL);
				ShowMenu_Main(client);
			}
			case 3: ShowMenu_Settings(client);
		}
	}
	else if(action == MenuAction_Cancel && param == MenuCancel_ExitBack) Shop_ShowFunctionsMenu(client);
	else if(action == MenuAction_End) CloseHandle(menu);
}

ShowMenu_Games(client)
{
	new Handle:menu = CreateMenu(Games_MenuHandler);
	SetTitleMenu(menu, client);
	decl String:name[128];

	for(new i = 0; i < GetArraySize(Games); i++)
	{
		GetGameNameOfIndex(i, name, sizeof(name));
		AddMenuItem(menu, "", name);
	}

	if(GetMenuItemCount(menu) == 0) AddMenuItem(menu, "", "Нет доступных игр", ITEMDRAW_DISABLED);

	SetMenuExitBackButton(menu, true);
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public Games_MenuHandler(Handle:menu, MenuAction:action, client, param)
{
	if(action == MenuAction_Select)
	{
		GameOptions[client][Game] = param;
		ShowMenu_Bets(client);
	}
	else if(action == MenuAction_Cancel && param == MenuCancel_ExitBack) ShowMenu_Main(client);
	else if(action == MenuAction_End) CloseHandle(menu);
}

ShowMenu_Bets(client)
{
	new Handle:menu = CreateMenu(Bets_MenuHandler);
	SetTitleMenu(menu, client);

	for(new i = 0; i <= sizeof(g_sBets); i++)
	{
		new style;
		if(Shop_GetClientCredits(client) < StringToInt(g_sBets[i][Amount])) style = ITEMDRAW_DISABLED;

		if(g_sBets[i][Amount][0]) AddMenuItem(menu, g_sBets[i][Amount], g_sBets[i][Name], style);
		else break;
	}

	SetMenuExitBackButton(menu, true);
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public Bets_MenuHandler(Handle:menu, MenuAction:action, client, param)
{
	if(action == MenuAction_Select)
	{
		decl String:info[32];
		GetMenuItem(menu, param, info, sizeof(info));
		GameOptions[client][Bet] = StringToInt(info);

		if(!IsValidClient(client, GameOptions[client][Bet]))
		{
			VPrintToChat(client, "%s Недостаточно кредитов.", GPREFIX);
			ShowMenu_Bets(client);
		}
		else ShowMenu_Target(client);
	}
	else if(action == MenuAction_Cancel && param == MenuCancel_ExitBack) ShowMenu_Games(client);
	else if(action == MenuAction_End) CloseHandle(menu);
}

ShowMenu_Target(client)
{
	new Handle:menu = CreateMenu(Target_MenuHandler);

	decl String:title[100];
	FormatEx(title, sizeof(title), "%s \nВыберите игрока:\n \n", GTITLE);
	SetMenuTitle(menu, title);

	decl String:userid[10], String:name[64];
	for(new i = 1; i <= MaxClients; i++)
	{
		if(IsValidClient(i, GameOptions[client][Bet]) && client != i && !g_bClientCookie[i][GameOptions[client][Game]])
		{
			IntToString(GetClientUserId(i), userid, sizeof(userid));
			GetClientName(i, name, sizeof(name));
			Format(name, sizeof(name), "%s (%i)", name, Shop_GetClientCredits(i));

			new style;
			if(GameOptions[client][Started]) style = ITEMDRAW_DISABLED;

			AddMenuItem(menu, userid, name, style);
		}
	}

	if(GetMenuItemCount(menu) == 0) AddMenuItem(menu, "", "Нет подходящих игроков", ITEMDRAW_DISABLED);

	SetMenuExitBackButton(menu, true);
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public Target_MenuHandler(Handle:menu, MenuAction:action, client, param)
{
	if(action == MenuAction_Select)
	{
		decl String:info[32];
		GetMenuItem(menu, param, info, sizeof(info));

		new target = GetClientOfUserId(StringToInt(info));
		GameOptions[client][Target] = target;

		ShowMenu_Confirm(client);
	}
	else if(action == MenuAction_Cancel && param == MenuCancel_ExitBack) ShowMenu_Bets(client);
	else if(action == MenuAction_End) CloseHandle(menu);
}

ShowMenu_Confirm(client)
{
	new Handle:menu = CreateMenu(Confirm_MenuHandler);

	decl String:buffer[100], String:name[128];
	FormatEx(buffer, sizeof(buffer), "%s \nПодтверждение игры:\n \n", GTITLE);
	SetMenuTitle(menu, buffer);

	GetGameNameOfIndex(GameOptions[client][Game], name, sizeof(name));
	FormatEx(buffer, sizeof(buffer), "Игра: %s", name); AddMenuItem(menu, "", buffer, ITEMDRAW_DISABLED);
	FormatEx(buffer, sizeof(buffer), "Игрок: %N", GameOptions[client][Target]); AddMenuItem(menu, "", buffer, ITEMDRAW_DISABLED);
	FormatEx(buffer, sizeof(buffer), "Ставка: %i (Комиссия %i%%)\n \n", GameOptions[client][Bet], g_iCommission); AddMenuItem(menu, "", buffer, ITEMDRAW_DISABLED);

	AddMenuItem(menu, "", "Играть");

	SetMenuExitBackButton(menu, true);
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public Confirm_MenuHandler(Handle:menu, MenuAction:action, client, param)
{
	if(action == MenuAction_Select)
	{
		if(param == 3)
		{
			new target = GameOptions[client][Target];

			if(IsValidClient(target, GameOptions[client][Bet]) && !GameOptions[target][Started] && !g_bClientCookie[target][GameOptions[client][Game]])
			{
				VPrintToChat(client, "%s Предложение отправлено.", GPREFIX);
				ShowMenu_OfferToPlay(target, client);
			}
			else VPrintToChat(client, "%s Игрок недоступен.", GPREFIX);
		}
	}
	else if(action == MenuAction_Cancel && param == MenuCancel_ExitBack) ShowMenu_Target(client);
	else if(action == MenuAction_End) CloseHandle(menu);
}

ShowMenu_OfferToPlay(client, caller)
{
	GameOptions[client][Game] =		GameOptions[caller][Game];
	GameOptions[client][Bet] =		GameOptions[caller][Bet];
	GameOptions[client][Target] =	caller;
	GameOptions[client][Started] =	true;
	GameOptions[caller][Started] =	true;

	new Handle:menu = CreateMenu(OfferToPlay_MenuHandler);

	decl String:buffer[100], String:name[128];
	FormatEx(buffer, sizeof(buffer), "%s \nПоступило предложение:\n \n", GTITLE);
	SetMenuTitle(menu, buffer);

	GetGameNameOfIndex(GameOptions[caller][Game], name, sizeof(name));
	FormatEx(buffer, sizeof(buffer), "От: %N", caller); AddMenuItem(menu, "", buffer, ITEMDRAW_DISABLED);
	FormatEx(buffer, sizeof(buffer), "Игра: %s", name); AddMenuItem(menu, "", buffer, ITEMDRAW_DISABLED);
	FormatEx(buffer, sizeof(buffer), "Ставка: %i (Комиссия %i%%)\n \n", GameOptions[caller][Bet], g_iCommission); AddMenuItem(menu, "", buffer, ITEMDRAW_DISABLED);

	AddMenuItem(menu, "", "Принять");
	AddMenuItem(menu, "", "Отказаться");

	SetMenuExitButton(menu, false);
	DisplayMenu(menu, client, g_iConfirmTime);
}

public OfferToPlay_MenuHandler(Handle:menu, MenuAction:action, client, param)
{
	new caller;
	if(client > 0) caller = GameOptions[client][Target];

	if(action == MenuAction_Select)
	{
		if(param == 3)
		{
			VPrintToChat(caller, "%s Игрок \x04%N\x01 принял предложение. Игра начнется через \x04%i\x01 секунд(ы).", GPREFIX, client, g_iStartTime);
			CreateTimer(float(g_iStartTime), StartGame, client);
		}
		else
		{
			ResetGame(client, caller);
			VPrintToChat(client, "%s Вы отказались от игры.", GPREFIX);
			VPrintToChat(caller, "%s Игрок \x04%N\x01 отказался от игры.", GPREFIX, client);
		}
	}
	else if(action == MenuAction_Cancel)
	{
		ResetGame(client, caller);
		VPrintToChat(caller, "%s Игрок \x04%N\x01 не принял предложение.", GPREFIX, client);
	}
	else if(action == MenuAction_End) CloseHandle(menu);
}

ResetGame(client1, caller2 = 0)
{
	GameOptions[client1][Started] = false;
	GameOptions[caller2][Started] = false;
}

ShowMenu_Settings(client)
{
	new Handle:menu = CreateMenu(Settings_MenuHandler);

	decl String:buffer[256];
	FormatEx(buffer, sizeof(buffer), "%s \nНастройки:\n \n", GTITLE);
	SetMenuTitle(menu, buffer);

	FormatEx(buffer, sizeof(buffer), "[%s] Отключить меню результатов в конце игры\n \n", g_bClientCookieResult[client] ? "✓" : "   ");
	AddMenuItem(menu, "", buffer);

	decl Handle:trie, String:name[128];
	for(new i = 0; i < GetArraySize(Games); i++)
	{
		trie = GetArrayCell(Games, i);

		GetTrieString(trie, "name", name, sizeof(name));
		FormatEx(buffer, sizeof(buffer), "[%s] Игнорировать предложения %s", g_bClientCookie[client][i] ? "✓" : "   ", name);
		AddMenuItem(menu, "", buffer);
	}

	SetMenuExitBackButton(menu, true);
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public Settings_MenuHandler(Handle:menu, MenuAction:action, client, param)
{
	if(action == MenuAction_Select)
	{
		if(param == 0)
		{
			g_bClientCookieResult[client] = g_bClientCookieResult[client] ^ true;

			if(g_bClientCookieResult[client]) SetClientCookie(client, g_hCookieResultMenu, "1");
			else SetClientCookie(client, g_hCookieResultMenu, "0");
		}
		else
		{
			param -= 1;
			g_bClientCookie[client][param] = g_bClientCookie[client][param] ^ true;

			decl Handle:trie, Handle:cookie;
			trie = GetArrayCell(Games, param);
			GetTrieValue(trie, "cookie", cookie);

			if(g_bClientCookie[client][param]) SetClientCookie(client, cookie, "1");
			else SetClientCookie(client, cookie, "0");
		}

		ShowMenu_Settings(client);
	}
	else if(action == MenuAction_Cancel && param == MenuCancel_ExitBack) ShowMenu_Main(client);
	else if(action == MenuAction_End) CloseHandle(menu);
}

public Action:StartGame(Handle:timer, any:client)
{
	decl Handle:trie, Handle:plugin, Function:func;

	trie = GetArrayCell(Games, GameOptions[client][Game]);
	GetTrieValue(trie, "plugin", plugin);
	GetTrieValue(trie, "func", func);

	Call_StartFunction(plugin, func);
	Call_PushCell(client);
	Call_Finish();
}

GetWinCredits(bet) return RoundToNearest(float(bet) / 100 * (100 - g_iCommission * 2));

ResultGame(client, String:game_name[], String:buffer1[], String:buffer2[], bool:win = false)
{
	new bet = GameOptions[client][Bet], credits = GetWinCredits(bet);

	if(win)	Shop_GiveClientCredits(client, credits);
	else	Shop_TakeClientCredits(client, bet);

	decl String:buffer3[128];
	FormatEx(buffer3, sizeof(buffer3), "Вы %s %i кредитов", win ? "выиграли" : "проиграли", win ? bet + credits : bet);

	if(!g_bClientCookieResult[client])
	{
		new Handle:menu = CreateMenu(Result_MenuHandler);
		SetMenuTitle(menu, "%s:\n \n%s\n%s\n \n%s\n \n", game_name, buffer1, buffer2, buffer3);

		AddMenuItem(menu, "", "Закрыть");

		SetMenuExitButton(menu, false);
		DisplayMenu(menu, client, MENU_TIME_FOREVER);
	}

	VPrintToChat(client, "%s %s.", GPREFIX, buffer3);
	ResetGame(client);
}

public Result_MenuHandler(Handle:menu, MenuAction:action, client, param) if(action == MenuAction_End) CloseHandle(menu);

GetGameNameOfIndex(index, String:name[], size)
{
	new Handle:trie = GetArrayCell(Games, index);
	GetTrieString(trie, "name", name, size);
}

VPrintToChat(client, String:msg[], any:...)
{
	decl String:buffer[1024];
	VFormat(buffer, sizeof(buffer), msg, 3);

	if(IsValidClient(client)) PrintToChat(client, buffer);
}
