#include <sourcemod>
#include <shop_games>

#define GAME_ID		"knb"
#define GAME_NAME	"Камень-ножницы-бумага"

new Object[MAXPLAYERS+1];
new Time[MAXPLAYERS+1];

new const String:ObjectName[][] =
{
	"Камень",
	"Ножницы",
	"Бумага"
};

public Plugin:myinfo =
{
	name = "[Shop] Games (KNB)",
	author = "Monroe",
	version = "1.0"
};

public OnMapStart() Games_RegisterGame(GAME_ID, GAME_NAME, StartGame_KNB);

public StartGame_KNB(client1)
{
	new client2 = Games_GetClientEnemy(client1);
	if(!Games_IsClientInGame(client2)) return;

	ShowMenu_GameKNB(client1);
	ShowMenu_GameKNB(client2);

	if(!Games_IsValidClient(client1) || !Games_IsValidClient(client2)) Games_ResetGame(client1, client2);
}

ShowMenu_GameKNB(client)
{
	CreateTimer(1.0, HudGame_KNB, client, TIMER_REPEAT);

	PrintToChat(client, "%s Игра началась.", GPREFIX);
	Object[client] = -1;
	Time[client] = Games_GetGameTime();

	new Handle:menu = CreateMenu(GameKNB_MenuHandler);
	SetMenuTitle(menu, "Камень-ножницы-бумага:\n \n");

	AddMenuItem(menu, "", "Камень");
	AddMenuItem(menu, "", "Ножницы");
	AddMenuItem(menu, "", "Бумага");

	SetMenuExitButton(menu, false);
	DisplayMenu(menu, client, Games_GetGameTime());
}

public GameKNB_MenuHandler(Handle:menu, MenuAction:action, client1, param)
{
	new client2;
	if(client1 > 0) client2 = Games_GetClientEnemy(client1);

	if(action == MenuAction_Select)
	{
		Object[client1] = param;
		Time[client1] = 0;
		PrintHintText(client1, "%s", ObjectName[param]);

		if(Object[client1] >= 0 && Object[client2] >= 0)
		{
			new winner = GetKNBWinner(client1, client2);

			if(winner == 0)
			{
				PrintToChat(client1, "%s Ничья. Играем еще раз.", GPREFIX);
				PrintToChat(client2, "%s Ничья. Играем еще раз.", GPREFIX);

				StartGame_KNB(client1);
			}
			else
			{
				decl String:buffer1[128], String:buffer2[128];
				FormatEx(buffer1, sizeof(buffer1), "[%s] %N", ObjectName[Object[client1]], client1);
				FormatEx(buffer2, sizeof(buffer2), "[%s] %N", ObjectName[Object[client2]], client2);

				Games_ResultGame(winner, GAME_NAME, buffer2, buffer1, true);
				Games_ResultGame(Games_GetClientEnemy(winner), GAME_NAME, buffer2, buffer1);
			}
		}
		else PrintToChat(client1, "%s Игрок \x04%N\x01 еще не определился.", GPREFIX, client2);
	}
	else if(action == MenuAction_Cancel)
	{
		if(Games_IsClientInGame(client1))
		{
			Games_ResetGame(client1, client2);
			if(Games_IsValidClient(client2)) PrintToChat(client1, "%s Вы не успели определиться. Игра закончена.", GPREFIX);
			if(Games_IsValidClient(client2)) PrintToChat(client2, "%s Игрок \x04%N\x01 не успел определиться. Игра закончена.", GPREFIX, client1);
		}
	}
	else if(action == MenuAction_End) CloseHandle(menu);
}

public Action:HudGame_KNB(Handle:timer, any:client)
{
	if(!Games_IsValidClient(client) || Time[client] <= 0) return Plugin_Stop;

	PrintHintText(client, "%i", Time[client]);
	Time[client] -= 1;

	return Plugin_Continue;
}

GetKNBWinner(client1, client2)
{
	new c1 = Object[client1], c2 = Object[client2];
	if(c1 == 0 && c2 == 2 || c1 == 1 && c2 == 0 || c1 == 2 && c2 == 1) return client2;
	else if(c1 == 0 && c2 == 1 || c1 == 1 && c1 == 2 || c1 == 2 && c2 == 0) return client1;
	return 0;
}
